# 画面設計書 15-Menubar - Help

## 概要

本ドキュメントは、three.js エディタにおけるヘルプメニュー（Menubar - Help）の画面設計書である。このメニューは、エディタのソースコード、three.js公式サイト、エディタマニュアルへの外部リンクを提供する。

### 本画面の処理概要

**業務上の目的・背景**：3Dエディタを使用するユーザーが、追加の情報やドキュメントを必要とした際に、適切なリソースへ素早くアクセスできることは重要である。このメニューは、エディタのソースコード（GitHub）、three.jsの公式サイト、およびエディタの使い方を説明するWikiマニュアルへのリンクを一箇所に集約し、ユーザーの学習・トラブルシューティングを支援する。

**画面へのアクセス方法**：エディタメイン画面（editor/index.html）のメニューバー領域に常時表示される。「Help」メニュータイトルをクリックすると、ドロップダウン形式でオプションが展開される。

**主要な操作・処理内容**：
1. **Source Code**：GitHubのthree.js editorソースコードページを新しいタブで開く
2. **About**：three.js公式サイト（threejs.org）を新しいタブで開く
3. **Manual**：GitHubのエディタマニュアル（Wiki）を新しいタブで開く

**画面遷移**：すべてのメニュー項目は外部リンクであり、新しいブラウザタブが開かれる。エディタ自体の画面状態は変化しない。

**権限による表示制御**：特別な権限制御は存在しない。すべてのユーザーがすべてのリンクにアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | EventDispatcher | 主機能 | ヘルプ関連イベントの管理 |

## 画面種別

メニュー（ドロップダウン）

## URL/ルーティング

エディタメイン画面の一部として `editor/index.html` に含まれる。独立したルーティングは持たない。

## 入出力項目

なし（外部リンクのみ）

## 表示項目

| 項目 | 表示内容 | リンク先 |
|------|---------|---------|
| Source Code | エディタのソースコード | https://github.com/mrdoob/three.js/tree/master/editor |
| About | three.js公式サイト | https://threejs.org |
| Manual | エディタマニュアル | https://github.com/mrdoob/three.js/wiki/Editor-Manual |

## イベント仕様

### 1-Source Code（ソースコード）

- **トリガー**：Source Codeメニュー項目クリック
- **処理内容**：
  1. `window.open('https://github.com/mrdoob/three.js/tree/master/editor', '_blank')` を実行
- **画面更新**：新しいタブでGitHubのeditorディレクトリが開かれる

### 2-About（概要）

- **トリガー**：Aboutメニュー項目クリック
- **処理内容**：
  1. `window.open('https://threejs.org', '_blank')` を実行
- **画面更新**：新しいタブでthree.js公式サイトが開かれる

### 3-Manual（マニュアル）

- **トリガー**：Manualメニュー項目クリック
- **処理内容**：
  1. `window.open('https://github.com/mrdoob/three.js/wiki/Editor-Manual', '_blank')` を実行
- **画面更新**：新しいタブでGitHub Wikiのエディタマニュアルページが開かれる

## データベース更新仕様

本画面はブラウザ上で動作する3Dエディタであり、データベースへの直接的な更新は行わない。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| なし | - | 本メニューでは特別なメッセージ表示はない |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ポップアップブロッカー | ブラウザのポップアップブロッカーが有効な場合、新しいタブが開かれない可能性がある |

## 備考

- すべてのリンクは `_blank` ターゲットで開かれ、エディタの作業状態に影響を与えない
- コメントアウトされた「Icons」メニュー項目（Flaticon）が存在するが、現在は無効化されている
- 多言語対応のため、メニュー項目のテキストは `strings.getKey()` で取得される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Menubar.Help.js | `editor/js/Menubar.Help.js` | メニュー構築と外部リンク処理 |

**主要処理フロー**:
1. **3-17行目**: UIPanel/UIRowを使用したメニュー構造の構築
2. **19-29行目**: Source Codeメニュー項目（GitHubへのリンク）
3. **31-43行目**: コメントアウトされたIconsメニュー項目
4. **45-55行目**: Aboutメニュー項目（threejs.orgへのリンク）
5. **57-67行目**: Manualメニュー項目（GitHub Wikiへのリンク）

**読解のコツ**: このファイルは非常にシンプルで、window.open()による外部リンク処理のみを行う。

### プログラム呼び出し階層図

```
MenubarHelp (Menubar.Help.js)
    │
    ├─ sourceCode.onClick()
    │      └─ window.open('https://github.com/mrdoob/three.js/tree/master/editor', '_blank')
    │
    ├─ about.onClick()
    │      └─ window.open('https://threejs.org', '_blank')
    │
    └─ manual.onClick()
           └─ window.open('https://github.com/mrdoob/three.js/wiki/Editor-Manual', '_blank')
```

### データフロー図

```
[入力]                    [処理]                         [出力]

メニュークリック ───────▶ Menubar.Help.js ──────────▶ window.open()
                              │                              │
                              │                              ▼
                              │                        新規タブで外部サイト表示
                              │
                              └─ (エディタ状態は変化なし)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Menubar.Help.js | `editor/js/Menubar.Help.js` | ソース | Helpメニューの主要実装 |
| ui.js | `editor/js/libs/ui.js` | ソース | UIコンポーネント（UIPanel, UIRow等） |
| Strings.js | `editor/js/Strings.js` | ソース | 多言語対応の文字列管理 |
